
##############################
# Country definition for ENG #
##############################

province =
{ id         = 5
  anti_air   = 4
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 10 current_size = 10 }
}              # Scapa Flow
province =
{ id       = 9
  anti_air = 2
  air_base = { size = 4 current_size = 4 }
}            # Glasgow
province =
{ id         = 13
  anti_air   = 2
  air_base   = { size = 10 current_size = 10 }
  naval_base = { size = 10 current_size = 10 }
}              # Sheffield
province =
{ id         = 14
  anti_air   = 4
  air_base   = { size = 10 current_size = 10 }
  naval_base = { size = 10 current_size = 10 }
}              # Liverpool
province = { id = 16 anti_air = 2 } # Birmingham
province =
{ id         = 17
  anti_air   = 4
  air_base   = { size = 10 current_size = 10 }
  naval_base = { size = 10 current_size = 10 }
}              # Norwich
province = { id = 19 anti_air = 3 } # London
province =
{ id          = 20
  anti_air    = 5
  air_base    = { size = 10 current_size = 10 }
  naval_base  = { size = 10 current_size = 10 }
  #landfort    = 0
  coastalfort = 3
}               # Dover
province =
{ id         = 21
  anti_air   = 6
  air_base   = { size = 10 current_size = 10 }
  naval_base = { size = 10 current_size = 10 }
}              # Portsmouth
province =
{ id         = 23
  anti_air   = 6
  air_base   = { size = 10 current_size = 10 }
  naval_base = { size = 10 current_size = 10 }
}              # Plymouth
province = { id = 28 oilpool = 1000 supplypool = 2000 } # Belfast
province =
{ id          = 31
  anti_air    = 2
  air_base    = { size = 4 current_size = 4 }
  naval_base  = { size = 5 current_size = 5 }
  coastalfort = 1
  oilpool     = 1000
  supplypool  = 1000
}               # Malta
province =
{ id          = 348
  anti_air    = 6
  air_base    = { size = 4 current_size = 4 }
  naval_base  = { size = 10 current_size = 10 }
  landfort    = 6
  oilpool     = 1000
  supplypool  = 1000
}               # Gibraltar
province =
{ id       = 444
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Cyprus
province =
{ id         = 538
  anti_air   = 1
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 4 current_size = 4 }
  oilpool    = 100
  supplypool = 500
}              # Bermuda
province =
{ id         = 576
  anti_air   = 2
  air_base   = { size = 6 current_size = 6 }
  naval_base = { size = 10 current_size = 10 }
}              # Newfoundland
province =
{ id       = 652
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Andros
province =
{ id         = 866
  anti_air   = 2
  air_base   = { size = 2 current_size = 2 }
  naval_base = { size = 5 current_size = 5 }
  oilpool    = 100
  supplypool = 200
}              # Falkland Islands
province =
{ id       = 873
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Georgetown
province = { id = 900 anti_air = 2 } # Suez
province = { id = 901 anti_air = 2 oilpool = 1000 supplypool = 2000 } # Port Said
province = { id = 903 anti_air = 2 } # Cairo
province =
{ id         = 906
  anti_air   = 5
  air_base   = { size = 7 current_size = 7 }
  naval_base = { size = 10 current_size = 10 }
}              # Alexandria
province =
{ id         = 988
  anti_air   = 1
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 2 current_size = 2 }
  oilpool    = 1000
  supplypool = 2000
}              # Freetown
province =
{ id       = 1002
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Accra
province =
{ id       = 1008
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Lagos
province =
{ id       = 1061
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Mombasa
province =
{ id       = 1066
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Khartoum
province =
{ id       = 1296
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Mandalay
province =
{ id         = 1299
  anti_air   = 3
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 10 current_size = 10 }
}              # Rangoon
province =
{ id          = 1315
  anti_air    = 4
  air_base    = { size = 4 current_size = 4 }
  naval_base  = { size = 10 current_size = 10 }
  coastalfort = 1
  oilpool     = 1000
  supplypool  = 1000
}               # Hong Kong
province =
{ id          = 1353
  anti_air    = 6
  air_base    = { size = 8 current_size = 8 }
  naval_base  = { size = 10 current_size = 10 }
  coastalfort = 3
  oilpool     = 1000
  supplypool  = 2000
}               # Singapore
province =
{ id       = 1457
  anti_air = 2
  air_base = { size = 4 current_size = 4 }
}            # Calcutta
province =
{ id       = 1467
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Indore
province =
{ id       = 1469
  anti_air = 2
  air_base = { size = 4 current_size = 4 }
}            # Delhi
province =
{ id         = 1494
  anti_air   = 1
  air_base   = { size = 8 current_size = 8 }
  naval_base = { size = 8 current_size = 8 }
}              # Karachi
province =
{ id         = 1505
  anti_air   = 3
  air_base   = { size = 10 current_size = 10 }
  naval_base = { size = 10 current_size = 10 }
  oilpool    = 1000
  supplypool = 2000
}              # Bombay
province =
{ id       = 1514
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Cochin
province =
{ id         = 1516
  anti_air   = 1
  air_base   = { size = 2 current_size = 2 }
  naval_base = { size = 2 current_size = 2 }
}              # Trincomalee
province =
{ id          = 1517
  anti_air    = 2
  air_base    = { size = 10 current_size = 10 }
  naval_base  = { size = 10 current_size = 10 }
  coastalfort = 3
  oilpool     = 1000
  supplypool  = 2000
}               # Colombo
province =
{ id       = 1644
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Kuching
province = { id = 1797 anti_air = 1 } # Jerusalem
province =
{ id         = 1798
  anti_air   = 1
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 2 current_size = 2 }
}              # Tel Aviv
province =
{ id         = 1813
  anti_air   = 1
  naval_base = { size = 2 current_size = 2 }
}              # Aden
province =
{ id         = 1817
  anti_air   = 2
  air_base   = { size = 6 current_size = 6 }
  naval_base = { size = 10 current_size = 10 }
  oilpool    = 100
  supplypool = 200
}              # Diego Garcia Island

#####################
# Country main data #
#####################

country =
{ tag                    = ENG
  capital                = 19
  peacetime_ic_mod       = 0.5
  manpower               = 40
  # Resource Reserves
  energy                 = 1000
  metal                  = 1000
  rare_materials         = 500
  oil                    = 500
  supplies               = 500
  money                  = 70
  transports             = 1000
  escorts                = 150
  diplomacy =
  { relation =
    { tag        = AFG
      value      = -75
      guaranteed = { day = 11 month = february year = 1934 }
    }
    relation = { tag = ARG value = 75 }
    relation = { tag = AST value = 200 } # was access = yes 
    relation =
    { tag        = AUS
      value      = 75
      guaranteed = { day = 27 month = september year = 1934 }
    }
    relation = { tag = BEL value = 150 }
    relation = { tag = BHU value = 200 access = yes }
    relation = { tag = BUL value = 20 }
    relation = { tag = CAN value = 200 } # was access = yes
    relation = { tag = CUB value = 30 }
    relation = { tag = CZE value = 125 }
    relation =
    { tag        = DEN
      value      = 100
      guaranteed = { day = 30 month = august year = 1934 }
    }
    relation = { tag = ENG value = 50 }
    relation = { tag = EST value = 65 }
    relation = { tag = ETH value = 50 }
    relation = { tag = FIN value = 85 }
    relation = { tag = FRA value = 150 }
    relation = { tag = GER value = 1 }
    relation =
    { tag        = GRE
      value      = 50
      guaranteed = { day = 11 month = february year = 1934 }
    }
    relation = { tag = GUA value = 50 }
    relation = { tag = HOL value = 125 }
    relation = { tag = HON value = 50 }
    relation = { tag = HUN value = -50 }
    relation =
    { tag        = IRE
      value      = 25
      guaranteed = { day = 11 month = february year = 1934 }
    }
    relation =
    { tag        = IRQ
      value      = 100
      access     = yes
      guaranteed = { day = 11 month = february year = 1934 }
    }
    relation = { tag = ITA value = -50 }
    relation = { tag = JAP value = -25 }
    relation = { tag = LAT value = 65 }
    relation = { tag = LIT value = 65 }
    relation = { tag = MEX value = 50 }
    relation = { tag = NEP value = 200 access = yes }
    relation =
    { tag        = NOR
      value      = 90
      guaranteed = { day = 30 month = august year = 1934 }
    }
    relation = { tag = NZL value = 200 } # was access = yes
    relation =
    { tag        = OMN
      value      = 150
      access     = yes
      guaranteed = { day = 11 month = february year = 1934 }
    }
    relation =
    { tag        = PER
      value      = 25
      guaranteed = { day = 11 month = february year = 1934 }
    }
    relation = { tag = POL value = 50 }
    relation =
    { tag        = POR
      value      = 100
      guaranteed = { day = 30 month = december year = 1935 }
    }
    relation = { tag = ROM value = 50 }
    relation = { tag = SAF value = 200 } # was access = yes
    relation =
    { tag        = SAU
      value      = 100
      guaranteed = { day = 11 month = february year = 1934 }
    }
    relation =
    { tag        = SCH
      value      = 50
      guaranteed = { day = 16 month = may year = 1935 }
    }
    relation = { tag = SIA value = 70 }
    relation = { tag = SPR value = -10 }
    relation = { tag = SOV value = -25 }
    relation =
    { tag        = SWE
      value      = 80
      guaranteed = { day = 30 month = august year = 1934 }
    }
    relation =
    { tag        = TUR
      value      = 75
      guaranteed = { day = 11 month = february year = 1934 }
    }
    relation = { tag = USA value = 150 }
    relation = { tag = VEN value = -10 }
    relation =
    { tag        = YEM
      value      = 150
      access     = yes
      guaranteed = { day = 11 month = february year = 1934 }
    }
  }
  SpyInfo                = { country = "ENG" NumberOfSpies = 9 }
  #SpyInfo                = { country = "GER" NumberOfSpies = 8 }
  #SpyInfo                = { country = "FRA" NumberOfSpies = 9 }
  #SpyInfo                = { country = "SOV" NumberOfSpies = 6 }
  #SpyInfo                = { country = "CZE" NumberOfSpies = 6 }
  #SpyInfo                = { country = "AUS" NumberOfSpies = 3 }
  #SpyInfo                = { country = "SPR" NumberOfSpies = 6 }
  #SpyInfo                = { country = "POL" NumberOfSpies = 8 }
  #SpyInfo                = { country = "SWE" NumberOfSpies = 3 }
  #SpyInfo                = { country = "NOR" NumberOfSpies = 5 }
  #SpyInfo                = { country = "FIN" NumberOfSpies = 6 }
  #SpyInfo                = { country = "YUG" NumberOfSpies = 8 }
  #SpyInfo                = { country = "HUN" NumberOfSpies = 6 }
  #SpyInfo                = { country = "BUL" NumberOfSpies = 6 }
  #SpyInfo                = { country = "BEL" NumberOfSpies = 8 }
  #SpyInfo                = { country = "DEN" NumberOfSpies = 3 }
  #SpyInfo                = { country = "HOL" NumberOfSpies = 8 }
  #SpyInfo                = { country = "USA" NumberOfSpies = 9 }
  #SpyInfo                = { country = "ALB" NumberOfSpies = 3 }
  #SpyInfo                = { country = "GRE" NumberOfSpies = 3 }
  #SpyInfo                = { country = "ARG" NumberOfSpies = 3 }
  #SpyInfo                = { country = "BRA" NumberOfSpies = 3 }
  #SpyInfo                = { country = "JAP" NumberOfSpies = 3 }
  #SpyInfo                = { country = "ROM" NumberOfSpies = 6 }
  #SpyInfo                = { country = "LIT" NumberOfSpies = 6 }
  #SpyInfo                = { country = "LUX" NumberOfSpies = 3 }
  #SpyInfo                = { country = "POR" NumberOfSpies = 3 }
  #SpyInfo                = { country = "ITA" NumberOfSpies = 6 }
  #SpyInfo                = { country = "CHI" NumberOfSpies = 9 }
  #SpyInfo                = { country = "MEX" NumberOfSpies = 3 }
  #SpyInfo                = { country = "AST" NumberOfSpies = 6 }
  #SpyInfo                = { country = "NZL" NumberOfSpies = 6 }
  #SpyInfo                = { country = "CAN" NumberOfSpies = 6 }
  #SpyInfo                = { country = "IRE" NumberOfSpies = 9 }
  #SpyInfo                = { country = "IRQ" NumberOfSpies = 8 }
  #SpyInfo                = { country = "BHU" NumberOfSpies = 3 }
  #SpyInfo                = { country = "YEM" NumberOfSpies = 3 }
  #SpyInfo                = { country = "ETH" NumberOfSpies = 3 }
  # GREAT BRITAIN
  nationalprovinces      = { 3    5    6    7    8    9    10   11   12   13   14   15   16   17   19   20   21   22   23   28   29   348  31   1494
                             1481 1480 1465 1466 1479 1482 1483 1475 1476 1478 1477 1469 1470 1471 1472 1456 1468 1467 1464 1463 1474 1460 1459 1457
                             1458 1461 1508 1462 1505 1506 1507 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 1284 1285 1286 1287 1288 1289
                             1290 1291 1898 1304 1295 1296 1301 1302 1346 1299 1298 1300 1292 1454 1297 1878 1877 444 
                           }
  # GREAT BRITAIN
  ownedprovinces         = { 3    5    6    7    8    9    10   11   12   13   14   15   16   17   19   20   21   22   23   28   29   348  31   444 
                             1494 1481 1480 1465 1466 1479 1482 1483 1475 1476 1478 1477 1469 1470 1471 1472 1456 1468 1467 1464 1463 1474 1460 1459
                             1457 1458 1461 1508 1462 1505 1506 1507 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 1284 1285 1286 1287 1288
                             1289 1290 1291 1898 1304 1295 1296 1301 1302 1346 1299 1298 1300 1292 1454 1297 1878 1877 1799 1797 1796 404  1802 1803
                             406  407  1813 1814 1820 1822 1504 1798 900  901  902  903  904  905  906  907  908  909  910  911  912  913  914  915 
                             4    1020 1019 1021 1022 1027 1023 1026 1024 1025 1800 1801 1065 1066 1069 1068 1067 1029 1028 1032 1031 1030 1040 1041
                             1349 1350 1351 1352 1353 1644 1646 1647 1315 758  891  871  873  806  807  808  809  897  538  652  653  664  665  666 
                             668  805  896  866  1147 1148 1816 1817 1136 1815 1132 1139 1062 1140 1141 1064 1060 1061 1059 1035 1036 1112 1111 1105
                             1124 1125 1104 1099 1129 1126 1128 1000 1001 1002 1008 1007 999  1009 1010 1011 1145 1085 1012 988  982  1622 1683 1684
                             1685 1686 1763 1761 1767 1768 1769 1770 1757 1759 1760 1752 1753 1754 1755 1758 575  576  1614 1611
                           }
  # GREAT BRITAIN
  controlledprovinces    = { 3    5    6    7    8    9    10   11   12   13   14   15   16   17   19   20   21   22   23   28   29   348  31   444 
                             1494 1481 1480 1465 1466 1479 1482 1483 1475 1476 1478 1477 1469 1470 1471 1472 1456 1468 1467 1464 1463 1474 1460 1459
                             1457 1458 1461 1508 1462 1505 1506 1507 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 1284 1285 1286 1287 1288
                             1289 1290 1291 1898 1304 1295 1296 1301 1302 1346 1299 1298 1300 1292 1454 1297 1878 1877 1799 1797 1796 404  1802 1803
                             406  407  1813 1814 1820 1822 1504 1798 900  901  902  903  904  905  906  907  908  909  910  911  912  913  914  915 
                             4    1020 1019 1021 1022 1027 1023 1026 1024 1025 1800 1801 1065 1066 1069 1068 1067 1029 1028 1032 1031 1030 1040 1041
                             1349 1350 1351 1352 1353 1644 1646 1647 1315 758  891  871  873  806  807  808  809  897  538  652  653  664  665  666 
                             668  805  896  866  1147 1148 1816 1817 1136 1815 1132 1139 1062 1140 1141 1064 1060 1061 1059 1035 1036 1112 1111 1105
                             1124 1125 1104 1099 1129 1126 1128 1000 1001 1002 1008 1007 999  1009 1010 1011 1145 1085 1012 988  982  1622 1683 1684
                             1685 1686 1763 1761 1767 1768 1769 1770 1757 1759 1760 1752 1753 1754 1755 1758 575  576  1614 1611
                           }
  # Commonwealth Tech '36
  # UK 1936 techs
  # ######################
  techapps               = { 4010  4020  4120  4130  2150  2010  2020  2030  2290  2300  2310  2450  2460  2510  1010  1020  1190  1200  1210  1220 
                             4220  1110  2400  1150  1310  5010  5020  5050  5080  5090  5190  5200  5310  5320  5410  5470  5480  3420  9010  9020 
                             9030  9140  6010  6030  6110  6120  8010  8020  8030  8040  8050  8070  8100  8120  3010  3020  3030  3070  3080  3090 
                             12100 12110
					  3100  3130  3140  3150  3190  3200  3210  3250  3260  3270  3280  3320  3330  3340  3400  3410  14000
                           }
  policy =
  { date              = { year = 0 month = january day = 0 }
    democratic        = 10
    political_left    = 2
    freedom           = 10
    free_market       = 8
    professional_army = 7
    defense_lobby     = 3
    interventionism   = 6
  }
  headofstate            = { type = 9 id = 1001 }
  headofgovernment       = { type = 9 id = 1002 }
  foreignminister        = { type = 9 id = 1003 }
  armamentminister       = { type = 9 id = 1004 }
  ministerofsecurity     = { type = 9 id = 1005 }
  ministerofintelligence = { type = 9 id = 1006 }
  chiefofstaff           = { type = 9 id = 1007 }
  chiefofarmy            = { type = 9 id = 1008 }
  chiefofnavy            = { type = 9 id = 1009 }
  chiefofair             = { type = 9 id = 1010 }
	### United Kingdom Land OOB ###
  landunit =
  { name     = "Ф˾ "
    location = 22
    id       = { type = 12700 id = 1 }
    division =
    { id       = { type = 12700 id = 1706 }
      name     = "еָӲ "
      type     = hq
      model    = 0
      strength = 100
    }
    division =
    { id            = { type = 12700 id = 2 }
      name          = "1ʦ "
      type          = infantry
      extra         = artillery
      brigade_model = 2
      strength      = 100
    }
    division =
    { id       = { type = 12700 id = 3 }
      name     = "2ʦ "
      type     = infantry
      strength = 100
    }
  }
  landunit =
  { name     = "˾ "
    location = 10
    id       = { type = 12700 id = 4 }
    division =
    { id       = { type = 12700 id = 5 }
      name     = "5ʦ "
      type     = infantry
      strength = 100
    }
  }
  landunit =
  { name     = "Ϸ˾ "
    location = 21
    id       = { type = 12700 id = 6 }
    division =
    { id       = { type = 12700 id = 7 }
      name     = "3ʦ "
      type     = infantry
      strength = 100
    }
  }
  landunit =
  { name     = "˾ "
    location = 1315
    id       = { type = 12700 id = 8 }
    division =
    { id       = { type = 12700 id = 9 }
      name     = "۷ "
      type     = garrison
      strength = 100
      locked   = yes
    }
  }
  landunit =
  { name     = "¼˾ "
    location = 1353
    id       = { type = 12700 id = 10 }
    division =
    { id       = { type = 12700 id = 11 }
      name     = "¼· "
      type     = garrison
      strength = 100
      locked   = yes
    }
  }
  landunit =
  { name     = "ֱ˾ "
    location = 348
    id       = { type = 12700 id = 12 }
    division =
    { id       = { type = 12700 id = 13 }
      name     = "ֱӷ "
      type     = garrison
      strength = 100
      locked   = yes
    }
  }
  landunit =
  { name     = "˾ "
    location = 1517
    id       = { type = 12700 id = 14 }
    division =
    { id       = { type = 12700 id = 15 }
      name     = " "
      type     = garrison
      strength = 100
      locked   = yes
    }
  }
  landunit =
  { name     = "˾ "
    location = 31
    id       = { type = 12700 id = 16 }
    division =
    { id       = { type = 12700 id = 17 }
      name     = " "
      type     = garrison
      strength = 100
      locked   = yes
    }
  }
  landunit =
  { name     = "ж˾ "
    location = 1797
    id       = { type = 12700 id = 18 }
    division =
    { id       = { type = 12700 id = 19 }
      name     = "7ʦ "
      type     = infantry
      strength = 100
    }
    division =
    { id       = { type = 12700 id = 20 }
      name     = "8ʦ "
      type     = infantry
      strength = 100
    }
  }
  landunit =
  { name     = "һӡȾ "
    location = 1469
    id       = { type = 12700 id = 21 }
    division =
    { id       = { type = 12700 id = 22 }
      name     = "1ӡʦ "
      type     = infantry
      strength = 100
    }
  }
  landunit =
  { name     = "ڶӡȾ "
    location = 1285
    id       = { type = 12700 id = 23 }
    division =
    { id            = { type = 12700 id = 24 }
      name          = "2ӡʦ "
      type          = infantry
      extra         = artillery
      brigade_model = 2
      strength      = 100
    }
  }
  landunit =
  { name     = "ӡȾ "
    location = 1299
    id       = { type = 12700 id = 25 }
    division =
    { id       = { type = 12700 id = 26 }
      name     = "3ӡʦ "
      type     = infantry
      strength = 100
    }
  }
  landunit =
  { name     = "ӡȾ "
    location = 1494
    id       = { type = 12700 id = 27 }
    division =
    { id       = { type = 12700 id = 28 }
      name     = "4ӡʦ "
      type     = infantry
      strength = 100
    }
  }
  landunit =
  { name     = "ӡȾ "
    location = 1478
    id       = { type = 12700 id = 29 }
    division =
    { id       = { type = 12700 id = 30 }
      name     = "5ӡʦ "
      type     = infantry
      extra    = engineer
      strength = 100
    }
  }
  landunit =
  { name     = "ӡȾ "
    location = 1461
    id       = { type = 12700 id = 31 }
    division =
    { id       = { type = 12700 id = 32 }
      name     = "6ӡʦ "
      type     = infantry
      strength = 100
    }
  }
  landunit =
  { name     = "ӡȾ "
    location = 1505
    id       = { type = 12700 id = 33 }
    division =
    { id       = { type = 12700 id = 34 }
      name     = "7ӡʦ "
      type     = infantry
      strength = 100
    }
  }
  landunit =
  { name     = "ڰӡȾ "
    location = 1513
    id       = { type = 12700 id = 35 }
    division =
    { id       = { type = 12700 id = 36 }
      name     = "8ӡʦ "
      type     = infantry
      extra    = anti_tank
      strength = 100
    }
  }
  landunit =
  { name     = "ھӡȾ "
    location = 1509
    id       = { type = 12700 id = 37 }
    division =
    { id       = { type = 12700 id = 38 }
      name     = "9ӡʦ "
      type     = infantry
      strength = 100
    }
  }
  landunit =
  { name     = "ʮӡȾ "
    location = 1514
    id       = { type = 12700 id = 39 }
    division =
    { id       = { type = 12700 id = 40 }
      name     = "10ӡʦ "
      type     = infantry
      strength = 100
    }
  }
  landunit =
  { name     = "ʮһӡȾ "
    location = 1515
    id       = { type = 12700 id = 41 }
    division =
    { id       = { type = 12700 id = 42 }
      name     = "11ӡʦ "
      type     = infantry
      strength = 100
    }
  }
  landunit =
  { name     = "ʮӡȾ "
    location = 1516
    id       = { type = 12700 id = 43 }
    division =
    { id       = { type = 12700 id = 44 }
      name     = "12ӡʦ "
      type     = infantry
      extra    = engineer
      strength = 100
    }
  }
  landunit =
  { name     = "յֳ "
    location = 1065
    id       = { type = 12700 id = 45 }
    division =
    { id       = { type = 12700 id = 46 }
      name     = "1յֳʦ "
      type     = militia
      strength = 100
    }
  }
  landunit =
  { name     = "յֳ "
    location = 1066
    id       = { type = 12700 id = 47 }
    division =
    { id       = { type = 12700 id = 48 }
      name     = "2յֳʦ "
      type     = militia
      strength = 100
    }
  }
  landunit =
  { name     = "յֳ "
    location = 1041
    id       = { type = 12700 id = 49 }
    division =
    { id       = { type = 12700 id = 50 }
      name     = "3յֳʦ "
      type     = militia
      strength = 100
    }
  }
  landunit =
  { name     = "ڸɴֳ "
    location = 1064
    id       = { type = 12700 id = 51 }
    division =
    { id       = { type = 12700 id = 52 }
      name     = "1ڸɴֳʦ "
      type     = militia
      strength = 100
    }
  }
  landunit =
  { name     = "ڸɴֳ "
    location = 1060
    id       = { type = 12700 id = 53 }
    division =
    { id       = { type = 12700 id = 54 }
      name     = "2ڸɴֳʦ "
      type     = militia
      strength = 100
    }
  }
  landunit =
  { name     = "ֳ "
    location = 1064
    id       = { type = 12700 id = 55 }
    division =
    { id       = { type = 12700 id = 56 }
      name     = "1ֳʦ "
      type     = militia
      strength = 100
    }
  }
  landunit =
  { name     = "ֳ "
    location = 1059
    id       = { type = 12700 id = 57 }
    division =
    { id       = { type = 12700 id = 58 }
      name     = "2ֳʦ "
      type     = militia
      strength = 100
    }
  }
  landunit =
  { name     = "̹ɣֳ "
    location = 1061
    id       = { type = 12700 id = 59 }
    division =
    { id       = { type = 12700 id = 60 }
      name     = "1̹ɣֳʦ "
      type     = militia
      strength = 100
    }
  }
  landunit =
  { name     = "̹ɣֳ "
    location = 1141
    id       = { type = 12700 id = 61 }
    division =
    { id            = { type = 12700 id = 62 }
      name          = "2̹ɣֳʦ "
      type          = militia
      strength      = 100
      extra         = artillery
      brigade_model = 0
    }
  }
	### UK Navy OOB ###
  navalunit =
  { name     = "Ӣ "
    id       = { type = 12700 id = 84 }
    location = 5 # Scapa Flow
    base     = 5
    division =
    { id    = { type = 12700 id = 85 }
      name  = "ɶѷ "
      type  = battleship
      model = 2
    }
    division =
    { id    = { type = 12700 id = 86 }
      name  = "޵ "
      type  = battleship
      model = 2
    }
    division =
    { id    = { type = 12700 id = 87 }
      name  = "Ȩ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 12700 id = 88 }
      name  = "ʼ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 12700 id = 89 }
      name  = "ĺ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 12700 id = 90 }
      name  = "˹ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 12700 id = 91 }
      name  = "º "
      type  = battlecruiser
      model = 2
    }
    division =
    { id    = { type = 12700 id = 92 }
      name  = " "
      type  = battlecruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 252 }
      name  = " "
      type  = battlecruiser
      model = 1
    }
    division =
    { id            = { type = 12700 id = 93 }
      name          = "ŭ "
      type          = carrier
      model         = 1
      extra         = cag
      brigade_model = 2
    }
    division =
    { id    = { type = 12700 id = 96 }
      name  = "޺ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 97 }
      name  = "Ǻ "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 12700 id = 98 }
      name  = "ᶡ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 99 }
      name  = "Ǻ "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 12700 id = 100 }
      name  = "Ի "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 12700 id = 101 }
      name  = "1֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 12700 id = 102 }
      name  = "2֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 12700 id = 103 }
      name  = "3֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 12700 id = 268 }
      name  = "4֧ "
      type  = destroyer
      model = 0
    }
  }
  navalunit =
  { id       = { type = 12700 id = 104 }
    name     = "۾ "
    location = 5 # Scapa Flow
    base     = 5
    division =
    { id            = { type = 12700 id = 105 }
      name          = "۾˺ "
      type          = escort_carrier
      model         = 0
    }
  }
  # 2nd Submarine Squadron#
  navalunit =
  { name     = "ڶǱͧ "
    id       = { type = 12700 id = 106 }
    location = 5 # Scapa Flow
    base     = 5
    division =
    { id    = { type = 12700 id = 107 }
      name  = "3Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 12700 id = 108 }
      name  = "4Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 12700 id = 109 }
      name  = "5Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 12700 id = 110 }
      name  = "6Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 12700 id = 111 }
      name  = "7Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
  }
  # 1st Transport Squadron#
  navalunit =
  { name     = "һ "
    id       = { type = 12700 id = 112 }
    location = 1505 # Hyderabad
    base     = 1505
    division =
    { id    = { type = 12700 id = 113 }
      name  = "˸ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 12700 id = 114 }
      name  = " "
      type  = transport
      model = 0
    }
  }
  # 2nd Transport Squadron#
  navalunit =
  { name     = "ڶ "
    id       = { type = 12700 id = 117 }
    location = 21 # Southampton
    base     = 21
    division =
    { id    = { type = 12700 id = 118 }
      name  = "۹ǹ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 12700 id = 119 }
      name  = " "
      type  = transport
      model = 0
    }
  }
  # 3rd Transport Squadron#
  navalunit =
  { name     = " "
    id       = { type = 12700 id = 122 }
    location = 21 # Southampton
    base     = 21
    division =
    { id    = { type = 12700 id = 123 }
      name  = " "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 12700 id = 124 }
      name  = "۹ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 12700 id = 125 }
      name  = "˹ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 12700 id = 126 }
      name  = "۹ħ "
      type  = transport
      model = 0
    }
  }
  # 4th Transport Squadron#
  navalunit =
  { name     = "4 "
    id       = { type = 12700 id = 127 }
    location = 5 # Scapa Flow
    base     = 5
    division =
    { id    = { type = 12700 id = 128 }
      name  = "˹ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 12700 id = 129 }
      name  = " "
      type  = transport
      model = 0
    }
  }
  # 5th Transport Squadron#
  navalunit =
  { name     = "5 "
    id       = { type = 12700 id = 132 }
    location = 23 # Plymouth
    base     = 23
    division =
    { id    = { type = 12700 id = 133 }
      name  = "۹ҫ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 12700 id = 134 }
      name  = "ɽķ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 12700 id = 135 }
      name  = " "
      type  = transport
      model = 0
    }
  }
  # Non-Associated Destroyers#
  navalunit =
  { name     = "һ𽢱 "
    id       = { type = 12700 id = 137 }
    location = 23 # Plymouth
    base     = 23
    division =
    { id    = { type = 12700 id = 269 }
      name  = "5֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 12700 id = 138 }
      name  = "6֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 12700 id = 139 }
      name  = "7֧ "
      type  = destroyer
      model = 1
    }
  }
  navalunit =
  { name     = "ڶ𽢱 "
    id       = { type = 12700 id = 140 }
    location = 14
    base     = 14
    division =
    { id    = { type = 12700 id = 270 }
      name  = "8֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 12700 id = 141 }
      name  = "9֧ "
      type  = destroyer
      model = 1
    }
  }
  navalunit =
  { name     = "𽢱 "
    id       = { type = 12700 id = 142 }
    location = 14 # Actually based at Milford Haven, but that is located in the same province as Cardiff.
    base     = 14
    division =
    { id    = { type = 12700 id = 271 }
      name  = "10֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 12700 id = 143 }
      name  = "11𽢱 "
      type  = destroyer
      model = 1
    }
  }
  navalunit =
  { name     = "𽢱 "
    id       = { type = 12700 id = 144 }
    location = 21 # Southampton
    base     = 21
    division =
    { id    = { type = 12700 id = 272 }
      name  = "12֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 12700 id = 145 }
      name  = "13֧ "
      type  = destroyer
      model = 1
    }
  }
  navalunit =
  { name     = "𽢱 "
    id       = { type = 12700 id = 146 }
    location = 21 # Portsmouth
    base     = 21
    division =
    { id    = { type = 12700 id = 273 }
      name  = "14֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 12700 id = 147 }
      name  = "15֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 12700 id = 148 }
      name  = "16֧ "
      type  = destroyer
      model = 1
    }
  }
  navalunit =
  { name     = "к "
    id       = { type = 12700 id = 149 }
    location = 906 # Alexandria
    base     = 906
    division =
    { id    = { type = 12700 id = 150 }
      name  = "ɯŮ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 12700 id = 151 }
      name  = "ķ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 12700 id = 152 }
      name  = "¸Һ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 12700 id = 253 }
      name  = "Ǻ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 12700 id = 254 }
      name  = "ս "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 12700 id = 153 }
      name  = " "
      type  = battleship
      model = 1
    }
    division =
    { id            = { type = 12700 id = 154 }
      name          = " "
      type          = carrier
      model         = 1
      extra         = cag
      brigade_model = 2
    }
    division =
    { id            = { type = 12700 id = 157 }
      name          = "ٺ "
      type          = carrier
      model         = 1
      extra         = cag
      brigade_model = 2
    }
    division =
    { id    = { type = 12700 id = 158 }
      name  = "ĺ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 159 }
      name  = "׶غ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 160 }
      name  = "ʲպ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 161 }
      name  = "ɭ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 163 }
      name  = "غ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 164 }
      name  = "Լ˺ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 165 }
      name  = "Ĵ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 166 }
      name  = "ֺ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 167 }
      name  = " "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 168 }
      name  = "ǲ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 169 }
      name  = "° "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 170 }
      name  = "ˮ "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 12700 id = 171 }
      name  = "17֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 12700 id = 172 }
      name  = "18֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 12700 id = 173 }
      name  = "19֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 12700 id = 174 }
      name  = "20֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 12700 id = 175 }
      name  = "21֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 12700 id = 176 }
      name  = "22֧ "
      type  = destroyer
      model = 0
    }
  }
  # 1st Submarine Squadron#
  navalunit =
  { name     = "һǱͧ "
    id       = { type = 12700 id = 177 }
    location = 906 # Alexandria
    base     = 906
    division =
    { id    = { type = 12700 id = 178 }
      name  = "1Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 12700 id = 179 }
      name  = "2Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
  }
  # America & West Indies Station#
  navalunit =
  { name     = "-ӡȺ "
    id       = { type = 12700 id = 180 }
    location = 538 # Bermuda
    base     = 538
    division =
    { id    = { type = 12700 id = 181 }
      name  = " "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 182 }
      name  = "ֿ˹ "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 12700 id = 274 }
      name  = "23֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 12700 id = 183 }
      name  = "24֧ "
      type  = destroyer
      model = 0
    }
  }
  # Africa Station#
  navalunit =
  { name     = "޽ "
    id       = { type = 12700 id = 184 }
    location = 988 # Freetown
    base     = 988
    division =
    { id    = { type = 12700 id = 261 }
      name  = "º "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 12700 id = 185 }
      name  = " "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 275 }
      name  = "25֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 12700 id = 186 }
      name  = "26֧ "
      type  = destroyer
      model = 0
    }
  }
  # East Indies Station#
  navalunit =
  { name     = "ӡȽ "
    id       = { type = 12700 id = 187 }
    location = 1517
    base     = 1517
    division =
    { id    = { type = 12700 id = 188 }
      name  = "ŵ˺ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 189 }
      name  = "Ҷī˹ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 190 }
      name  = " "
      type  = light_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 191 }
      name  = "ĺ "
      type  = light_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 276 }
      name  = "27֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 12700 id = 192 }
      name  = "28֧ "
      type  = destroyer
      model = 0
    }
  }
  # China Station#
  navalunit =
  { name     = "й "
    id       = { type = 12700 id = 193 }
    location = 1315 # Hong Kong
    base     = 1315
    division =
    { id            = { type = 12700 id = 194 }
      name          = "ӥ "
      type          = escort_carrier
      model         = 1
    }
    division =
    { id    = { type = 12700 id = 201 }
      name  = "նغ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 202 }
      name  = "29֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 12700 id = 203 }
      name  = "30֧ "
      type  = destroyer
      model = 0
    }
  }
  # 3rd Submarine Squadron#
  navalunit =
  { name     = "Ǳͧ "
    id       = { type = 12700 id = 204 }
    location = 1315 # Hong Kong
    base     = 1315
    division =
    { id    = { type = 12700 id = 205 }
      name  = "8Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 12700 id = 206 }
      name  = "9Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
  }
  # Reserve Fleet#
  navalunit =
  { name     = "󱸽 "
    id       = { type = 12700 id = 207 }
    location = 21 # Southampton
    base     = 21
    division =
    { id            = { type = 12700 id = 208 }
      name          = "ʹߺ "
      type          = escort_carrier
	model 	  = 0
    }
    division =
    { id    = { type = 12700 id = 209 }
      name  = "Ҽķ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 210 }
      name  = "ޱ˹ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 211 }
      name  = "غ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 155 }
      name  = "˹ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 156 }
      name  = "˺ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 162 }
      name  = "ֶ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 195 }
      name  = " "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 196 }
      name  = "˺ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 197 }
      name  = "غ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 12700 id = 212 }
      name  = "º "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 12700 id = 213 }
      name  = "Ǻ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 214 }
      name  = " "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 215 }
      name  = "˺ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 216 }
      name  = "Ӷ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 217 }
      name  = "º "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 218 }
      name  = "ӵķ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 219 }
      name  = "Ů "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 220 }
      name  = "ƺ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 221 }
      name  = "ȶ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 222 }
      name  = " "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 12700 id = 223 }
      name  = "31֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 12700 id = 224 }
      name  = "32֧ "
      type  = destroyer
      model = 0
    }
  }
  # #################
  # Royal Airforce #
  # #################
  airunit =
  { location = 14
    base     = 14
    id       = { type = 12700 id = 63 }
    name     = "һսն "
    division =
    { id       = { type = 12700 id = 64 }
      name     = "1սը "
      type     = tactical_bomber
      model    = 0
      strength = 100
    }
  }
  airunit =
  { location = 17
    base     = 17
    id       = { type = 12700 id = 65 }
    name     = "ӢʼҿվսԺը˾ "
    division =
    { id       = { type = 12700 id = 66 }
      name     = "2սԺը "
      type     = strategic_bomber
      model    = 0
      strength = 100
    }
    division =
    { id       = { type = 12700 id = 68 }
      name     = "3սԺը "
      type     = strategic_bomber
      model    = 0
      strength = 100
    }
    division =
    { id       = { type = 12700 id = 70 }
      name     = "4սԺը "
      type     = strategic_bomber
      model    = 0
      strength = 100
    }
  }
  airunit =
  { location = 21
    base     = 21
    id       = { type = 12700 id = 251 }
    name     = "ڶսն "
    division =
    { id       = { type = 12700 id = 71 }
      name     = "5սը "
      type     = tactical_bomber
      model    = 0
      strength = 100
    }
  }
  airunit =
  { location = 14
    base     = 14
    id       = { type = 12700 id = 72 }
    name     = "һսն "
    division =
    { id       = { type = 12700 id = 73 }
      name     = "11ս "
      type     = interceptor
      model    = 0
      strength = 100
    }
  }
  airunit =
  { location = 21
    base     = 21
    id       = { type = 12700 id = 74 }
    name     = "ڶսն "
    division =
    { id       = { type = 12700 id = 75 }
      name     = "12ս "
      type     = interceptor
      model    = 0
      strength = 100
    }
  }
  airunit =
  { location = 21
    base     = 21
    id       = { type = 12700 id = 76 }
    name     = "սն "
    division =
    { id       = { type = 12700 id = 77 }
      name     = "13ս "
      type     = interceptor
      model    = 0
      strength = 100
    }
  }
  airunit =
  { location = 1798
    base     = 1798
    id       = { type = 12700 id = 78 }
    name     = "жվ˾ "
    division =
    { id       = { type = 12700 id = 79 }
      name     = "ж "
      type     = tactical_bomber
      model    = 0
      strength = 100
    }
  }
  airunit =
  { location = 1505
    base     = 1505
    id       = { type = 12700 id = 80 }
    name     = "ӡȿվ˾ "
    division =
    { id       = { type = 12700 id = 81 }
      name     = "ӡȴ "
      type     = tactical_bomber
      model    = 0
      strength = 100
    }
  }
  airunit =
  { location = 1353
    base     = 1353
    id       = { type = 12700 id = 82 }
    name     = "Զվ˾ "
    division =
    { id       = { type = 12700 id = 83 }
      name     = "Զ "
      type     = tactical_bomber
      model    = 0
      strength = 100
    }
  }
  # Warships Under Construction#
  division_development =
  { name  = "33֧ "
    type  = destroyer
    model = 1
    cost  = 1.5
    id    = { type = 12700 id = 500 }
    date  = { year = 1936 month = march day = 1 }
  }
  division_development =
  { name  = "34֧ "
    type  = destroyer
    model = 1
    cost  = 1.5
    id    = { type = 12700 id = 501 }
    date  = { year = 1936 month = april day = 1 }
  }
  division_development =
  { name  = "10Ǳ֧ͧ "
    type  = submarine
    model = 2
    cost  = 1.5
    id    = { type = 12700 id = 502 }
    date  = { year = 1936 month = march day = 1 }
  }
}
